; String.asm - demonstrates use of strings in a resource file
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

%include "String.ash"

[BITS 32]
[section .text]

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	;
	; Before we can use the strings, we need to load them into memory. This
	; is done by the LoadString function, which takes four parameters -
	;
	;   1. Module instance which holds the resource,
	;   2. Resource identifier,
	;   3. Buffer address to store the string
	;   4. Maximum number of characters to copy
	;
	; Since the resources are in the executable we can use hInstance for the
	; first parameter and the others should be obvious :)
	;
	; Notice how I've named the resource identifiers the same name as the
	; labels in the source to make things easier to remember
	;
	sc LoadString, .hInstance, IDS_szClassName, _szClassName, 255
	sc LoadString, .hInstance, IDS_szWndCaption, _szWndCaption, 255
	sc LoadString, .hInstance, IDS_szWndText, _szWndText, 255
	sc LoadString, .hInstance, IDS_szError_title, _szError_title, 255
	sc LoadString, .hInstance, IDS_szError_msg, _szError_msg, 255
	;
	; Now do the usual window creation and message painting, but
	; using the loaded strings rather than local variables. I've
	; commented where any loaded strings are used
	;
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	;
	; loaded string - class name
	;
	mov	[esi + WNDCLASSEX.lpszClassName], dword _szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	;
	; loaded string - window caption
	;
	sc CreateWindowEx, 0, _szClassName, _szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	;
	; loaded strings - error message box caption and text
	;
	sc MessageBox, NULL, _szError_msg, _szError_title, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	endlocals
	CallbackPrologue
	switch .message
		case WM_PAINT
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			;
			; loaded string - window text
			;
			sc DrawText, ._hdc, _szWndText, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc EndPaint, .hwnd, ._ps
			xor	eax,eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax,eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	CallbackEpilogue
endproc

[section .bss]
;
; Space for the strings to be loaded into. Note the use of the
; TEXTRES macro which reserves space for the number of _chararcters_
; specified. Hence, if you switch to Unicode you just reassemble.
;
_szClassName	TEXTRES 255
_szWndCaption	TEXTRES 255
_szWndText	TEXTRES 255
_szError_title	TEXTRES 255
_szError_msg	TEXTRES 266

[section .data]
